<?php 
date_default_timezone_set('America/Lima');
//Inclu��mos inicialmente la conexi��n a la base de datos
require "../config/Conexion.php";
//session_start(); 
Class Miscursos
{
	//Implementamos nuestro constructor
	public function __construct()
	{

	}
    public function listar($idusuario)
    {
        //$idusuario = $_SESSION['idusuario'];
        $sql = "SELECT t1.id_cursos, t1.cur_nombre, t2.ni_nombre, t3.gra_nombre, t5.sec_Nombre, t6.id_GruComp
                FROM t_cursos t1
                    INNER JOIN t_nivel t2 ON t2.id_nivel = t1.id_nivel
                    INNER JOIN t_grado t3 ON t3.id_grado = t1.id_grado
                    INNER JOIN usuario t4 ON t4.idusuario = t1.idusuario
                    INNER JOIN t_seccion t5 ON t1.id_sec = t5.id_sec
                    INNER JOIN t_competenciascursos t6 ON t6.id_cursos = t1.id_cursos
                WHERE t4.idusuario = $idusuario 
                GROUP BY t1.id_cursos";
        return ejecutarConsulta($sql);
    }
    public function listargeneral()
    {
        //$idusuario = $_SESSION['idusuario'];
        $sql = "SELECT t1.id_cursos, t1.cur_nombre, t2.ni_nombre, t3.gra_nombre, t5.sec_Nombre 
                FROM t_cursos t1
                    INNER JOIN t_nivel t2 ON t2.id_nivel = t1.id_nivel
                    INNER JOIN t_grado t3 ON t3.id_grado = t1.id_grado
                    INNER JOIN usuario t4 ON t4.idusuario = t1.idusuario
                    INNER JOIN t_seccion t5 ON t5.id_sec = t1.id_sec";
        return ejecutarConsulta($sql);
    }

    public function insertaridcusrodocente( $id_curso, $idusuario)
    {
        $sql = "INSERT INTO `t_cursodocente` ( `id_curso`, `idusuario`) VALUES ($id_curso, $idusuario)";
        return ejecutarConsulta($sql);
    }

    public function editaridcusrodocente($id_curso, $idusuario)
    {
        $sql = "UPDATE `t_cursodocente` SET `id_curso`= $id_curso WHERE `idusuario` = $idusuario";
        return ejecutarConsulta($sql);
    }

    public function verificaridcursodocente($idusuario)
    {
        $sql = "SELECT COUNT(`id_cursodocente`) AS 'numero' FROM `t_cursodocente` WHERE `idusuario` = $idusuario";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function idcursodocente($idusuario)
    {
        $sql = "SELECT t1.id_cursodocente, t1.id_curso, t1.idusuario, t2.id_cursooficial 
                FROM t_cursodocente t1
                    INNER JOIN t_cursos t2 ON t2.id_cursos = t1.id_curso
                WHERE t1.idusuario = $idusuario";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function listaralumnoscurso($id_curso,$idusuario)
    {
        $sql = "SELECT * FROM t_cursos t1 
                    INNER JOIN t_anioescolar t2 ON t1.id_nivel = t1.id_nivel 
                    INNER JOIN t_alumnos t3 ON t2.idalumno = t3.idalumnos  
                WHERE t1.id_cursos = $id_curso AND t1.idusuario = $idusuario AND t2.id_grado = t1.id_grado AND t2.id_nivel = t1.id_nivel AND t3.estado = 1 AND t1.id_sec = t2.id_sec
                ORDER BY t3.apellidos ASC";
        return ejecutarConsulta($sql);
    }
    public function contarnotasregistrascurso($id_anioescolaractual, $id_curso, $id_etapamensual)
    {
        $sql = "SELECT COUNT(`id_notasmensuales`) AS 'numero' FROM `t_notasmensuales` WHERE `id_anioescolaractual` = $id_anioescolaractual AND `id_cursos` = $id_curso AND `id_etapamensual` = $id_etapamensual";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function contaralumnoscurso($id_curso,$idusuario)
    {        
        $sql = "SELECT COUNT(t1.id_nivel) AS 'numero' FROM t_cursos t1 INNER JOIN t_anioescolar t2 ON t1.id_nivel = t1.id_nivel AND t1.id_grado = t2.id_grado INNER JOIN t_alumnos t3 ON t2.idalumno =t3.idalumnos WHERE t1.id_cursos = $id_curso AND t1.idusuario = $idusuario AND t1.id_grado = t2.id_grado AND t1.id_nivel = t2.id_nivel AND t3.estado = 1";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function porcentarjeporcurso($id_curso, $idusuario, $id_anioescolaractual, $id_etapamensual)
    {
        $sql = "SELECT ((SELECT COUNT(`id_notasmensuales`) AS 'numero' FROM `t_notasmensuales` WHERE `id_anioescolaractual` = $id_anioescolaractual AND `id_cursos` = $id_curso AND `id_etapamensual` = $id_etapamensual) * 100) / (SELECT COUNT(t1.id_cursos) AS 'numero' FROM t_cursos t1 INNER JOIN t_anioescolar t2 ON t1.id_nivel = t1.id_nivel INNER JOIN t_alumnos t3 ON t2.idalumno =t3.idalumnos WHERE t1.id_cursos = $id_curso AND t1.idusuario = $idusuario AND t3.estado = 1 AND t2.id_grado = t1.id_grado AND t2.id_nivel = t1.id_nivel AND t1.id_sec = t2.id_sec) AS 'numero' FROM DUAL";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function porcentarjeporcursotrimestral($id_curso, $idusuario, $id_anioescolaractual, $id_estapatrimestral)
    {
        $sql = "SELECT ((SELECT COUNT(distinct `idalumno`) AS 'numero' 
                FROM `t_notastrimestrales`
                WHERE `id_anioescolaractual` = $id_anioescolaractual 
                    AND `id_cursos` = $id_curso 
                    AND `id_etapatrimestral` = $id_estapatrimestral) * 100) / (SELECT COUNT(t1.id_cursos) AS 'numero' 
                                                                                FROM t_cursos t1 
                                                                                    INNER JOIN t_anioescolar t2 ON t1.id_nivel = t1.id_nivel 
                                                                                    INNER JOIN t_alumnos t3 ON t2.idalumno = t3.idalumnos 
                                                                                WHERE t1.id_cursos = $id_curso 
                                                                                    AND t1.idusuario = $idusuario 
                                                                                    AND t3.estado = 1 AND t2.id_grado = t1.id_grado 
                                                                                    AND t2.id_nivel = t1.id_nivel AND t1.id_sec = t2.id_sec) AS 'numero' FROM DUAL";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function porcentarjeporcursogeneral($id_curso, $id_anioescolaractual, $id_etapamensual)
    {
        $sql = "SELECT ((SELECT COUNT(`id_notasmensuales`) AS 'numero' FROM `t_notasmensuales` WHERE `id_anioescolaractual` = $id_anioescolaractual AND `id_cursos` = $id_curso AND `id_etapamensual` = $id_etapamensual) * 100) / (SELECT COUNT(t1.id_cursos) AS 'numero' FROM t_cursos t1 INNER JOIN t_anioescolar t2 ON t1.id_nivel = t1.id_nivel INNER JOIN t_alumnos t3 ON t2.idalumno =t3.idalumnos WHERE t1.id_cursos = $id_curso AND t2.id_grado = t1.id_grado AND t3.estado = 1 AND t2.id_nivel = t1.id_nivel) AS 'numero' FROM DUAL";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function porcentarjeporcursotrimestralgeneral($id_curso, $id_anioescolaractual, $id_estapatrimestral)
    {        
        $sql = "SELECT ((SELECT COUNT(distinct `idalumno`) AS 'numero' 
                FROM `t_notastrimestrales`
                WHERE `id_anioescolaractual` = $id_anioescolaractual 
                    AND `id_cursos` = $id_curso 
                    AND `id_etapatrimestral` = $id_estapatrimestral) * 100) / (SELECT COUNT(t1.id_cursos) AS 'numero' 
                                                                                FROM t_cursos t1 
                                                                                    INNER JOIN t_anioescolar t2 ON t1.id_nivel = t1.id_nivel 
                                                                                    INNER JOIN t_alumnos t3 ON t2.idalumno = t3.idalumnos 
                                                                                WHERE t1.id_cursos = $id_curso                                                                                     
                                                                                    AND t3.estado = 1 AND t2.id_grado = t1.id_grado 
                                                                                    AND t2.id_nivel = t1.id_nivel) AS 'numero' FROM DUAL";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function verificernotasperiodoactual($id_anioescolaractual, $id_cursos, $idalumnos, $id_etapamensual)
    {
        $sql = "SELECT COUNT(`id_notasmensuales`) AS 'numero' FROM `t_notasmensuales` WHERE `id_anioescolaractual` = $id_anioescolaractual AND `id_cursos` = $id_cursos AND `idalumno` = $idalumnos AND `id_etapamensual` = $id_etapamensual"; 
        return ejecutarConsultaSimpleFila($sql);
    }
    public function vernotasperiodoactual($id_anioescolaractual, $id_cursos, $idalumnos, $id_etapamensual)
    {
        $sql = "SELECT * FROM `t_notasmensuales` WHERE `id_anioescolaractual` = $id_anioescolaractual AND `id_cursos` = $id_cursos AND `idalumno` = $idalumnos AND `id_etapamensual` = $id_etapamensual";
    }
    public function alumnoscursoseleccionado($id_docente, $id_curso)
    {
        $sql = "SELECT t2.idalumno, t4.nombre FROM t_cursos t1 INNER JOIN t_anioescolar t2 ON t1.id_nivel = t2.id_nivel INNER JOIN t_anioescolar t3 ON t1.id_grado = t3.id_grado INNER JOIN t_alumnos t4 ON t4.idalumnos = t2.idalumno WHERE t1.id_cursos = $id_curso AND t4.estado = 1 AND t1.idusuario = $id_docente GROUP BY t2.idalumno";
        return ejecutarConsulta($sql);
    }    
    public function verificarnotacurso($id_alumno, $id_etapamensual, $id_curso)
    {
        $sql = "SELECT COUNT(`id_notasmensuales`) AS 'numero' FROM `t_notasmensuales` WHERE `idalumno` = $id_alumno AND `id_etapamensual` = $id_etapamensual AND `id_cursos` = $id_curso";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function verificarnotacursotrimestral($id_alumno, $id_estapatri, $id_curso)
    {
        $sql = "SELECT * FROM `t_notastrimestrales` WHERE `idalumno` = $id_alumno AND `id_etapatrimestral` = $id_estapatri AND `id_cursos` = $id_curso";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function etapamensualactual()
    {
        $sql = "SELECT * FROM `t_etapamensual` WHERE CURDATE() BETWEEN `ep_inicio` AND `ep_fin`";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function etapatrimestralactual()
    {
        $sql = "SELECT * FROM `t_etapatrimestral` WHERE CURDATE() BETWEEN `et_inicio` AND `et_fin`";
        return ejecutarConsultaSimpleFila($sql);
    }
    function cursoactual($id_docente)
    {
        $sql = "SELECT * FROM t_cursodocente t1 
                    INNER JOIN t_cursos t2 ON t1.id_curso = t2.id_cursos 
                    INNER JOIN t_nivel t3 ON t3.id_nivel = t2.id_nivel 
                    INNER JOIN t_grado t4 ON t4.id_grado = t2.id_grado 
                    INNER JOIN t_seccion t5 ON t2.id_sec = t5.id_sec
                    INNER JOIN t_competenciascursos t6 ON t2.id_cursos = t6.id_cursos
                WHERE t1.idusuario = $id_docente
                GROUP BY t2.id_cursos";
        // $sql = "SELECT * FROM t_cursos t1
        //             INNER JOIN t_nivel t2 ON t1.id_nivel = t2.id_nivel
        //             INNER JOIN t_grado t3 ON t1.id_grado = t3.id_grado
        //             INNER JOIN t_seccion t4 on t1.id_sec = t4.id_sec
        //             INNER JOIN t_seccion t5 ON t1.id_sec = t5.id_sec
        //         WHERE t1.idusuario = $id_docente";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function listarcompetencias($id_curso)
    {
        //$sql = "SELECT * FROM `t_competenciascursos` WHERE `id_cursooficial` = $id_cursooficial";
        $sql = "SELECT t3.* FROM t_cursos t1
                    INNER JOIN t_competenciascursos t2 ON t1.id_cursos = t2.id_cursos
                    INNER JOIN t_competencia t3 ON t3.id_comp = t2.id_comp
                WHERE t1.id_cursos = $id_curso";
        return ejecutarConsulta($sql);
    }
    public function notasporcursoalumno($id_alumno, $id_curso, $id_etapamensual, $id_anioescolaractual)
    {
        $sql = "SELECT * FROM `t_notasmensuales` WHERE `idalumno` = $id_alumno AND `id_cursos` = $id_curso AND `id_etapamensual` = $id_etapamensual AND `id_anioescolaractual` = $id_anioescolaractual";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function anioescolaractual()
    {
        $sql = "SELECT * FROM `t_anioescolaractual` WHERE CURDATE() BETWEEN `aea_inicio` AND `aea_fin`";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function insertarnotas($nota, $notaasistencia, $descripcion, $id_anioescolaractual, $id_curso, $id_alumno, $id_etapamensual)
    {
        $sql = "INSERT INTO `t_notasmensuales`(`nme_nota`, `nme_notaasistencia`,  `nme_descripcion`, `id_anioescolaractual`, `id_cursos`, `idalumno`, `id_etapamensual`) VALUES ($nota, $notaasistencia, '$descripcion', $id_anioescolaractual, $id_curso, $id_alumno, $id_etapamensual)";        
        return ejecutarConsulta($sql);
    }
    public function insertarnotastrimestrales($nota,$notaasistencia,$descripcion,$anioescolar,$id_curso,$id_alumno,$id_etapatrimestral,$id_competencia,$id_tiponota)
    {        
        $sql = "INSERT INTO `t_notastrimestrales`( `ntri_nota`, `ntri_notaasistencia`, `ntri_descripcion`, `id_anioescolaractual`, `id_cursos`, `idalumno`, `id_etapatrimestral`, `id_competencias`,`id_tiponota`) VALUES
                                                 ('$nota',$notaasistencia,'$descripcion',$anioescolar,$id_curso,$id_alumno,$id_etapatrimestral,$id_competencia,$id_tiponota)";
        return ejecutarConsulta($sql);
    }
    //insetar notas 0
    public function insertarnotastrimestralescero($notaasistencia,$descripcion,$anioescolar,$id_curso,$id_alumno,$id_etapatrimestral,$id_competencia,$id_tiponota)
    {        
        $sql = "INSERT INTO `t_notastrimestrales`( `ntri_nota`, `ntri_notaasistencia`, `ntri_descripcion`, `id_anioescolaractual`, `id_cursos`, `idalumno`, `id_etapatrimestral`, `id_competencias`,`id_tiponota`) VALUES
                                                 ('0',$notaasistencia,'$descripcion',$anioescolar,$id_curso,$id_alumno,$id_etapatrimestral,$id_competencia,$id_tiponota)";
        return ejecutarConsulta($sql);
    }

    public function competenciasporcurso($id_curso)
    {
        $sql = "SELECT * FROM t_cursos t1
                    INNER JOIN t_competenciascursos t2 ON t1.id_cursos = t2.id_cursos
                    INNER JOIN t_competencia t3 ON t2.id_comp = t3.id_comp
                WHERE t1.id_cursos = $id_curso";
        return ejecutarConsulta($sql);
    }
    public function listarcompetenciastrimestrales($id_curso,$id_alumno, $id_etapatrimestral)
    {
        $sql = "SELECT * FROM t_cursos t1 
                    INNER JOIN t_grupocompetenciadetalle t2 ON t1.id_GruComp = t2.id_GruComp
                    INNER JOIN t_competencia t3 ON t3.id_comp = t2.id_comp
                    INNER JOIN t_notastrimestrales t4 ON t4.id_competencias = t3.id_comp
                    INNER JOIN t_alumnos t5 ON t5.idalumnos = t4.idalumno
                WHERE t1.id_cursos = $id_curso AND t5.idalumnos = $id_alumno AND t4.id_etapatrimestral = $id_etapatrimestral 
                    AND `id_anioescolaractual` = (SELECT `id_anioescolaractual` FROM `t_anioescolaractual` WHERE `aea_estado` = 1)";
        return ejecutarConsulta($sql);
    }
    public function listarnotastrimestrales($id_alumno, $id_curso, $id_estapatrimestral)
    {
        $sql = "SELECT * FROM `t_notastrimestrales` WHERE `idalumno` = $id_alumno AND `id_cursos` = $id_curso AND `id_etapatrimestral` = $id_estapatrimestral AND `id_tiponota` = 1";
        return ejecutarConsulta($sql);
    }
    public function descripcioncompetencias($id_alumno, $id_curso, $id_estapatrimestral, $id_competencia)
    {
        $sql = "SELECT * FROM `t_notastrimestrales` WHERE `id_cursos` = $id_curso  AND `id_etapatrimestral` = $id_estapatrimestral   AND `id_tiponota` = 1 AND `idalumno` = $id_alumno AND `id_competencias` = $id_competencia";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function promediofinaltrimestre($id_alumno, $id_curso, $id_estapatrimestral)
    {
        $sql = "SELECT * FROM `t_notastrimestrales` WHERE `idalumno` = $id_alumno AND `id_cursos` = $id_curso AND `id_etapatrimestral` = $id_estapatrimestral AND `id_tiponota` = 4";
        return ejecutarConsulta($sql);
    }
    public function listarnotatrimestralasistencia($id_alumno, $id_curso, $id_estapatrimestral)
    {
        $sql = "SELECT * FROM `t_notastrimestrales` WHERE `idalumno` = $id_alumno AND `id_cursos` = $id_curso AND `id_etapatrimestral` = $id_estapatrimestral AND `ntri_nota` = 'N-R' AND `ntri_descripcion` = 'N-R'";
        return ejecutarConsultaSimpleFila($sql);
    }

    public function listarnotatrimestraldescripcion($id_alumno, $id_curso, $id_estapatrimestral)
    {
        //se filtra solo para competencias de apreciacion docente
        //$sql = "SELECT * FROM `t_notastrimestrales` WHERE `idalumno` = $id_alumno AND `id_cursos` = $id_curso AND `id_etapatrimestral` = $id_estapatrimestral AND `ntri_nota` = 'N-R' AND `ntri_notaasistencia` = 101";
        $sql = "SELECT * FROM `t_notastrimestrales` 
                WHERE   `idalumno` = $id_alumno 
                        AND `id_cursos` = $id_curso 
                        AND `id_etapatrimestral` = $id_estapatrimestral 
                        AND `ntri_nota` = 'N-R'
                        and `id_competencias` = 43";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function datoscurso($id_curso)
    {
        $sql = "SELECT * FROM `t_cursos` WHERE `id_cursos` = $id_curso";
        return ejecutarConsultaSimpleFila($sql);
    }
    public function editarcompetencia($id_notatrimestral, $descripcion)
    {
        $sql = "UPDATE `t_notastrimestrales` SET `ntri_descripcion` = '$descripcion' WHERE `id_notastrimestrales` = $id_notatrimestral";
        return ejecutarConsulta($sql);
    }

    //eliminar duplicado notas
    public function eliminarnotasdiplicadas($id_curso, $id_etapamensual)
    {
        $sql = "DELETE t1 FROM t_notasmensuales t1
        INNER JOIN t_notasmensuales t2 
        WHERE t1.id_notasmensuales > t2.id_notasmensuales and t1.idalumno = t2.idalumno
        AND t1.id_cursos = t2.id_cursos AND t2.id_cursos = $id_curso AND t1.id_etapamensual = $id_etapamensual";
        return ejecutarConsulta($sql);
    }

    //listar notas cualitativas
    public function listarnotascualitativas() {
        $sql = "SELECT `id_notcuali`, `notcuali_nota` FROM `t_notascualitativas` WHERE id_notcuali <> 1";
        return ejecutarConsulta($sql);
    }

    //listar notas cualitativas ultimo estapa
    public function listarnotascualitativasultimo() {
        $sql = "SELECT `id_notcuali`, `notcuali_nota` FROM `t_notascualitativas`";
        return ejecutarConsulta($sql);
    }

    //obtenr datos competencia trimestral
    public function datoscompetenciastrimestrales($id_notatrimestral) {
        $sql = "SELECT * FROM t_notastrimestrales t1
                    INNER JOIN t_competencia t2 ON t1.id_competencias = t2.id_comp
                WHERE t1.id_notastrimestrales = $id_notatrimestral";
        return ejecutarConsultaSimpleFila($sql);
    }

    //editar nota trimestral
    public function editarnotatrimestral($id_notatri,$notatrimestral) {
        $sql = "UPDATE `t_notastrimestrales` SET `ntri_nota` = '$notatrimestral' WHERE `id_notastrimestrales` = $id_notatri";
        return ejecutarConsulta($sql);
    }

    //editar nota trimestral
    public function editardescripciontrimestral($id_notatri,$descripcion) {
        $sql = "UPDATE `t_notastrimestrales` SET `ntri_descripcion` = '$descripcion' WHERE `id_notastrimestrales` = $id_notatri";
        return ejecutarConsulta($sql);
    }
}