var tabla;
var tablappff;

//Función que se ejecuta al inicio
function init() {
    mostrarform(false);
    cerrarppff();
    listar();

    $("#formulario").on("submit", function (e) {
        guardaryeditar(e);
    })

}

//Función limpiar
function limpiar() {
    $("#idalumnos").val("");
    $("#dni").val("");
    $("#nombre").val("");
    $("#apellidos").val("");
    $("#direccion").val("");
    $("#telefono").val("");
}

//Función mostrar formulario
function mostrarform(flag) {
    limpiar();
    if (flag) {
        $("#listadoregistros").hide();
        $("#formularioregistros").show();
        $("#btnGuardar").prop("disabled", false);
        $("#btnagregar").hide();
    } else {
        $("#listadoregistros").show();
        $("#formularioregistros").hide();
        $("#btnagregar").show();
    }
}

//Función cancelarform
function cancelarform() {
    limpiar();
    mostrarform(false);
}

//Función Listar
function listar() {
    tabla = $('#tbllistado').dataTable({
        /*"scrollY": 200,  navegar en el datatable
        "scrollX": true, */
        // "paging": true,
        // "lengthChange": true,
        // "searching": true,
        // "ordering": true,
        // "info": true,
        // "autoWidth": false,
        
        // responsive: true,
        // "scrollX": true,

        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        lengthMenu: [
            [ 5, 10, 25, 50, -1 ],
            [ '5 filas','10 filas', '25 filas', '50 filas', 'Mostrar todo' ]
        ],
        buttons: [
                  {
                        extend: 'pageLength',
                        text: 'LONGITUD DE LA PÁGINA',
                   },
                    // {
                    //     extend: 'print',
                    //     text: 'IMPRIMIR',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
                    // {
                    //     extend: 'pdf',
                    //     text: 'DESCARGAR PDF',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
		        ],
        "ajax": {
            url: '../ajax/alumnos.php?op=listar',
            type: "get",
            dataType: "json",
            error: function (e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 10, //Paginación
        "order": [[0, "desc"]], //Ordenar (columna,orden)
        language: {
            zeroRecords: 'No hay registros para mostrar.',
            info: "Mostrando página _PAGE_ de _PAGES_ páginas",
            search: 'BUSCAR',
            emptyTable: 'La tabla está vacia.',
            "oPaginate": {
            "sFirst":    "Primero",
            "info":      true,
            "sLast":     "Ultimo",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior",
            }
        }
    }).DataTable();
}

//Función para guardar o editar
function guardaryeditar(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento
    $("#btnGuardar").prop("disabled", true);
    var formData = new FormData($("#formulario")[0]);

    $.ajax({
        url: "../ajax/alumnos.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,

        success: function (datos) {
            if (datos ==  1) {
                swal("Buen Trabajo!", "Alumno registrado correctamente!", "success");
            } else if (datos == 3) {
                swal("Buen Trabajo!", "Alumno actualizado correctamente!", "success");
            } else if (datos == 2) {
                swal("Error!", "No se pudo registrar al alumno!", "error");
            }else if (datos == 4){
				swal("Error!", "No se pudo actualizar los datos del alumno!", "error");
            }
            mostrarform(false);
            tabla.ajax.reload();
        }

    });
    limpiar();
}

function mostrar(idalumnos) {
    $.post("../ajax/alumnos.php?op=mostrar", {
        idalumnos: idalumnos
    }, function (data, status) {
        data = JSON.parse(data);
        mostrarform(true);
        
        $("#idalumnos").val(data.idalumnos);
        $("#dni").val(data.dni);
        $("#nombre").val(data.nombre);
        $("#apellidos").val(data.apellidos);
        $("#direccion").val(data.direccion);
        $("#telefono").val(data.telefono);

    });
    // $.post("../ajax/alumnos.php?op=permisos&id=" + idusuario, function (r) {
    //     $("#permisos").html(r);
    // });
}

//Función para desactivar registros
function desactivar(idalumnos) {
	swal({
        title: "DESACTIVAR ALUMNO",
        text: "El alumno sera excluido de las funciones del sistema",
        icon: "warning",
        buttons: true,
        dangerMode: true,		
      })
      .then((willDelete) => {  		      
        if (willDelete) {      
			
			$.post("../ajax/alumnos.php?op=desactivar", {idalumnos : idalumnos}, function(e){
				swal("Desactivado con éxito!", {
					icon: "success",
				});				
				tabla.ajax.reload();
			});		            
        } 
		else {
          swal("Se cancelo la desactivación");
        }
      });

}

//Función para activar registros
function activar(idalumnos) {

	swal({
        title: "ACTIVAR ALUMNO",
        text: "El alumno sera reintegrado de las funciones del sistema",
        icon: "warning",
        buttons: true,
        dangerMode: true,
      })
      .then((willDelete) => {  		      
        if (willDelete) {      
			
			$.post("../ajax/alumnos.php?op=activar", {idalumnos : idalumnos}, function(e){
				swal("Activado con éxito!", {
					icon: "success",
				});				
				tabla.ajax.reload();
			});		            
        } 
		else {
          swal("Se cancelo la activación");
        }
      });
}

function cargardatos(nombre) {    
    $("#nombre_alumnoppff").val(nombre); 
}

function mostrardatosppff(idalumno){ 
    listarppff(idalumno);
    $("#listadoregistros").hide();
    $("#btnagregar").hide();
    $("#listadoregistrosppffapoderado").show();
        
}

function cerrarppff() {
    $("#listadoregistros").show();
    $("#btnagregar").show();
    $("#listadoregistrosppffapoderado").hide();    
}
//Función Listar ppff
function listarppff(idalumno) {
    tablappff = $('#tbllistadoppff').dataTable({
        /*"scrollY": 200,  navegar en el datatable
        "scrollX": true, */
        // "paging": true,
        // "lengthChange": true,
        // "searching": true,
        // "ordering": true,
        // "info": true,
        // "autoWidth": false,        
        // responsive: true,
        // "scrollX": true,
        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        lengthMenu: [
            [ 5, 10, 25, 50, -1 ],
            [ '5 filas','10 filas', '25 filas', '50 filas', 'Mostrar todo' ]
        ],
        buttons: [
                  {
                        extend: 'pageLength',
                        text: 'LONGITUD DE LA PÁGINA',
                   },
                    // {
                    //     extend: 'print',
                    //     text: 'IMPRIMIR',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
                    // {
                    //     extend: 'pdf',
                    //     text: 'DESCARGAR PDF',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
		        ],
        "ajax": {
            url: '../ajax/alumnos.php?op=listarppff&idalumnoppff=' + idalumno,
            type: "get",
            dataType: "json",
            error: function (e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 10, //Paginación
        "order": [[0, "desc"]], //Ordenar (columna,orden)
        language: {
            zeroRecords: 'No hay registros para mostrar.',
            info: "Mostrando página _PAGE_ de _PAGES_ páginas",
            search: 'BUSCAR',
            emptyTable: 'La tabla está vacia.',
            "oPaginate": {
            "sFirst":    "Primero",
            "sLast":     "Ultimo",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior",
            }
        }
    }).DataTable();
}

init();
