var tabla;

//Funcion que se ejecuta al inicio

function init() {
    //VerificarAnioEscolar();

    $("#fmrmesevaluado").on("submit", function(e) {
        aperturarmesevaluado(e);
    })

    $("#fmranioescolar").on("submit", function(e) {
        aperturaranioescolar(e);
    })

    $("#fmrnuevafechaevaluacion").on("submit", function(e) {
        nuevafechaevaluacion(e);
    })

    $("#fmrnuevafechaevaluaciontrimestre").on("submit", function(e) {
        nuevafechaevaluaciontrimestral(e);
    })

    $("#fmrtrievaluado").on("submit", function(e) {
        aperturartrimestreevaluado(e);
    })
}

function VerificarAnioEscolar() {

    $.post("../ajax/consultas.php?op=VerificarAnioExcolar", {
    }, function(e) {
        var aux = parseInt(e);
        if (aux == 1) {

            const fechaActual = new Date();
            const añoActual = fechaActual.getFullYear();

            $("#IniciarAnio").show();
            $("#f_anio_esco").val(añoActual);
            
        } else {
            $("#IniciarAnio").hide();
        }
    });

}

function aperturarmesevaluado(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento    
    var formData = new FormData($("#fmrmesevaluado")[0]);
    $.ajax({
        url: "../ajax/consultas.php?op=aperturarmesevaluado",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos) {            
            if (datos == 1) {
                swal("Buen Trabajo!", "Etapa de evaluación mensual aperturada correctamente!", "success").then(()=>{
                        location.reload();
                    });
            }else{
                swal("Error!", "No se pudo aperturar etapa evaluación mensual!", "error");
            }
        }
    });
}

function aperturartrimestreevaluado(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento    
    var formData = new FormData($("#fmrtrievaluado")[0]);
    $.ajax({
        url: "../ajax/consultas.php?op=aperturartrimestreevaluado",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos) {
            if (datos ==  1) {                
                swal("Buen Trabajo!", "Etapa bimestral aperturada correctamente!", "success").then(()=>{                    
                    location.reload();
                });
            }else{                
                swal("Buen Trabajo!", "No se pudo aperturar etapa bimestral!", "success");
            }
        }
    });
}

function aperturaranioescolar(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento    
    var formData = new FormData($("#fmranioescolar")[0]);
    $.ajax({
        url: "../ajax/consultas.php?op=aperturaranioescolar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos) {
            if (datos ==  1) {
                swal("Buen Trabajo!", "Año escolar registrado correctamente!", "success").then(()=>{
                    VerificarAnioEscolar();
                    location.reload();
                });
            } else if(datos ==  3) {
                swal("Error!", "No se pudo registrar el año escolar!", "error").then(()=>{
                    VerificarAnioEscolar();
                    location.reload();
                });
            }else{
                swal("Error!", datos, "error").then(()=>{
                    VerificarAnioEscolar();
                    location.reload();
                });
            }
        }
    });
    
}

function nuevafechaevaluacion(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento    
    var formData = new FormData($("#fmrnuevafechaevaluacion")[0]);
    $.ajax({
        url: "../ajax/consultas.php?op=nuevafechaevaluacion",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos) {
            if (datos ==  1) {
                swal("Buen Trabajo!", "Se extendio la etapa de evaluación mensual correctamente!", "success").then(()=>{                    
                    location.reload();
                });
            }else{
                swal("Error!", "No se pudo extender la etapa mensual!", "error");
            }
        }
    });
}

function nuevafechaevaluaciontrimestral(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento    
    var formData = new FormData($("#fmrnuevafechaevaluaciontrimestre")[0]);
    $.ajax({
        url: "../ajax/consultas.php?op=nuevafechaevaluaciontrimestral",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos) {
            if (datos ==  1) {
                swal("Buen Trabajo!", "Se extendio la etapa de evaluación trimestral correctamente!", "success").then(()=>{                    
                    location.reload();
                });
            }else{                
                swal("Error!", "No se pudo extender la etapa bimestral!", "error");
            }
        }
    });
}

function finalizaranioescolar() {
    swal({
        title: "FINALIZAR AÑO ESCOLAR",
        text: "Esta a punto de finalizar el año escolar ¿Desea continuar con la operación?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {  		      
        if (willDelete) {      
            
            $.post("../ajax/consultas.php?op=finalizaranioescolar", {}, function(e){
                swal("Se finalizo el año escolar con éxito!", {
                    icon: "success",
                }).then(()=>{
                   location.reload();
                });                
            });		            
        } 
        else {
            swal("Se cancelo la operación");
        }
    });

}

function finalizarmesevaluacion() {

    swal({
        title: "FINALIZAR ETAPA MENSUAL DE EVALUACION",
        text: "¿Está Seguro de finalizar el més de evaluación?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {  		      
        if (willDelete) {      
            
            $.post("../ajax/consultas.php?op=finalizarmesevaluacion", {}, function(e){
                swal("Se finalizo la etapa mensual con éxito!", {
                    icon: "success",
                }).then(()=>{
                   location.reload();
                });                
            });		            
        } 
        else {
            swal("Se cancelo la operación");
        }
    });

}

function finalizartrimestreevaluacion() {

    swal({
        title: "FINALIZAR ETAPA BIMESTRAL DE EVALUACION",
        text: "¿Está Seguro de finalizar el bimestre de evaluación?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
    .then((willDelete) => {  		      
        if (willDelete) {      
            
            $.post("../ajax/consultas.php?op=finalizartrimestreevaluacion", {}, function(e){
                swal("Se finalizo la etapa bimenstral con éxito!", {
                    icon: "success",
                }).then(()=>{
                   location.reload();
                });                
            });		            
        } 
        else {
            swal("Se cancelo la operación");
        }
    });

}

init();