var tabla;

//Funcion que se ejecuta al inicio

function init() {
    mostrarform(false);
    listar();

    $("#formulario").on("submit", function(e) {
        editar(e);
    })

    //Cargamos los items al select docentes
    $.post("../ajax/registroalumnos.php?op=selectUsuario", function(r) {
        $("#idusuario").html(r);
        $('#idusuario').selectpicker('refresh');
    });
}

//Funcion Limpiar
function limpiar() {
    $("#idalumnos").val("");
    $("#dni").val("");
    $("#nombre").val("");
    $("#direccion").val("");
    $("#telefono").val("");
}

//Mostrar Formulario
function mostrarform(flag) {
    limpiar();
    if (flag) {
        $("#listadoregistros").hide();
        $("#formularioregistros").show();
        $("#btnGuardar").prop("disabled", false);
        $("#btnagregar").hide();
    } else {
        $("#listadoregistros").show();
        $("#formularioregistros").hide();
        $("#btnagregar").show();
    }
    //Cargamos los items al select docentes
    $.post("../ajax/registroalumnos.php?op=selectUsuario", function(r) {
        $("#idusuario").html(r);
        $('#idusuario').selectpicker('refresh');
    });
}

function cancelarform() {
    limpiar();
    mostrarform(false);
}


function listar() {
    tabla = $('#tbllistado').dataTable({
        /*"scrollY": 200,  navegar en el datatable
        "scrollX": true, */
         "paging": true,
        // "lengthChange": true,
        // "searching": true,
        "ordering": true,
         "info": true,
         "autoWidth": false,
        
        responsive: true,
        // "scrollX": true,

        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        lengthMenu: [
            [ 5, 10, 25, 50, -1 ],
            [ '5 filas','10 filas', '25 filas', '50 filas', 'Mostrar todo' ]
        ],
        buttons: [
                  {
                        extend: 'pageLength',
                        text: 'LONGITUD DE LA PÁGINA',
                   },
                    // {
                    //     extend: 'print',
                    //     text: 'IMPRIMIR',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
                    // {
                    //     extend: 'pdf',
                    //     text: 'DESCARGAR PDF',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
		        ],
        "ajax": {
            url: '../ajax/tutores.php?op=listar',
            type: "get",
            dataType: "json",
            error: function (e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 10, //Paginación
        "order": [[0, "asc"]], //Ordenar (columna,orden)
        language: {
            zeroRecords: 'No hay registros para mostrar.',
            info: "Mostrando página _PAGE_ de _PAGES_ páginas",
            search: 'BUSCAR',
            emptyTable: 'La tabla está vacia.',
            "oPaginate": {
            "sFirst":    "Primero",
            "sLast":     "Ultimo",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior",
            }
        }
    }).DataTable();
}

function editar(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento
    $("#btnGuardar").prop("disabled", true);
    var formData = new FormData($("#formulario")[0]);

    $.ajax({
        url: "../ajax/tutores.php?op=editar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,

        success: function(datos) {
            if (datos == 3) {
                swal("Nuevo tutor asignado correctamente!", {
					icon: "success",
				});								
            }else if (datos == 4){
                swal("Error al asignar tutor!", {
					icon: "error",
				});								                
            }
            mostrarform(false);
            tabla.ajax.reload();
        }
    });
    limpiar();
}

function mostrar(id_tutores) {
    $.post("../ajax/tutores.php?op=mostrar", {
        id_tutores: id_tutores
    }, function(data, status) {
        data = JSON.parse(data);
        mostrarform(true);

        $("#id_tutores").val(data.id_tutores);
        $("#ni_nombre").val(data.ni_nombre);
        $("#gra_nombre").val(data.gra_nombre);
        $("#sec_Nombre").val(data.sec_Nombre);
        $("#nombre").val(data.nombre);
    })
}

init();