var tabla;

//Funcion que se ejecuta al inicio

function init() {
    mostrarform(false);
    listar();
    iniciarcombos();

    $("#formulario").on("submit", function(e) {
        guardaryeditar(e);
    })

}

//Funcion Limpiar
function limpiar() {
    $("#cur_nombre").val("");
    iniciarcombos();
    $('#competencias').empty();
}

//Mostrar Formulario

function mostrarform(flag) {
    limpiar();
    if (flag) {
        $("#listadoregistros").hide();
        $("#formularioregistros").show();
        $("#btnGuardar").prop("disabled", false);
        $("#btnagregar").hide();
    } else {
        $("#listadoregistros").show();
        $("#formularioregistros").hide();
        $("#btnagregar").show();
    }
}

function cancelarform() {
    limpiar();
    mostrarform(false);
}


function listar() {
    tabla = $('#tbllistado').dataTable({
        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        buttons: [
            // 'copyHtml5',
            // 'excelHtml5',
            // 'pdf'
        ],
        "ajax": {
            url: '../ajax/cursos.php?op=listar',
            type: "get",
            dataType: "json",
            error: function(e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 10, //Paginación
        "order": [
                [2, "asc"]
            ] //Ordenar (columna,orden)
    }).DataTable();
}

function guardaryeditar(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento
    $("#btnGuardar").prop("disabled", true);
    var formData = new FormData($("#formulario")[0]);

    $.ajax({
        url: "../ajax/cursos.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,

        success: function(datos) {
            if (datos ==  1) {                
				swal("Curso registrado correctamente!", {
					icon: "success",
				});
            } else if (datos == 3) {
				swal("Curso actualizado correctamente!", {
					icon: "success",
				});
            } else if (datos == 2) {               
				swal("No se pudo registrar curso!", {
					icon: "error",
				});
            }else if (datos == 4){
				swal("No se pudo actualizar curso!", {
					icon: "success",
				});
            }
        }
    });
    limpiar();
    mostrarform(false);
    tabla.ajax.reload();
}

function mostrar(id_cursos) {
    $.post("../ajax/cursos.php?op=mostrar", {
        id_cursos: id_cursos
    }, function(data, status) {
        data = JSON.parse(data);
        mostrarform(true);

        $("#cur_nombre").val(data.cur_nombre);
        $("#id_nivel").val(data.id_nivel);
        $("#id_grado").val(data.id_grado);
        $("#idusuario").val(data.idusuario);
        $("#id_cursos").val(data.id_cursos);

    })
}

//Función para eliminar registros
function eliminar(id_cursos) {

	swal({
        title: "ELIMINAR CURSO",
        text: "¿Está Seguro de eliminar el Curso?",
        icon: "warning",
        buttons: true,
        dangerMode: true,
      })
      .then((willDelete) => {  		      
        if (willDelete) {      			
			$.post("../ajax/cursos.php?op=eliminar", {id_cursos : id_cursos}, function(e){
				swal("Curso esliminado exitosamente!", {
					icon: "success",
				});				
				tabla.ajax.reload();
			});		            
        } 
		else {
          swal("Se cancelo la operación");
        }
      });
    // bootbox.confirm("¿Está Seguro de eliminar el Curso?", function(result) {
    //     if (result) {
    //         $.post("../ajax/cursos.php?op=eliminar", { id_cursos: id_cursos }, function(e) {
    //             bootbox.alert(e);
    //             tabla.ajax.reload();
    //         });
    //     }
    // })
}

function iniciarcombos() {
    //Cargamos los items al select Nivel
    $.post("../ajax/registroalumnos.php?op=seleccionartNivel", function(r) {
        $("#id_nivel").html(r);
        $('#id_nivel').selectpicker('refresh');

    });

    // //Cargamos los items al select Nivel
    // $.post("../ajax/registroalumnos.php?op=selectGrado", function(r) {
    //     $("#id_grado").html(r);
    //     $('#id_grado').selectpicker('refresh');

    // });

    //Cargamos los items seccion
    $.post("../ajax/registroalumnos.php?op=seleccionarSeccion", function(r) {
        $("#id_seccion").html(r);
        $('#id_seccion').selectpicker('refresh');
    });

    //Cargamos los items al select docentes
    $.post("../ajax/registroalumnos.php?op=selectUsuarioDocente", function(r) {
        $("#idusuario").html(r);
        $('#idusuario').selectpicker('refresh');
    });

     //Cargamos los items al select docentes
     $.post("../ajax/cursos.php?op=ListarGrupoCompetencias", function(r) {
        $("#id_GruComp").html(r);
        $('#id_GruComp').selectpicker('refresh');

    });
}

//mostrar grados segun nivel
function cargargrado() {

    var id_nivel = document.getElementById("id_nivel").value;
    
    if (id_nivel == 1) {
        //Cargamos los items al select Nivel
        $.post("../ajax/registroalumnos.php?op=selectGradoPrimaria", function(r) {
            $("#id_grado").html(r);
            $('#id_grado').selectpicker('refresh');
        });

        $.post("../ajax/registroalumnos.php?op=seleccionarSeccion", function(r) {
            $("#id_seccion").html(r);
            $('#id_seccion').selectpicker('refresh');
        });
    } else if (id_nivel == 2) {
        //Cargamos los items al select Nivel
        $.post("../ajax/registroalumnos.php?op=selectGradoSecundaria", function(r) {
            $("#id_grado").html(r);
            $('#id_grado').selectpicker('refresh');
        });

        $.post("../ajax/registroalumnos.php?op=seleccionarSeccion", function(r) {
            $("#id_seccion").html(r);
            $('#id_seccion').selectpicker('refresh');
        });
    }else{
        //Cargamos los items al select Nivel
        $.post("../ajax/registroalumnos.php?op=selectGradoInicial", function(r) {
            $("#id_grado").html(r);
            $('#id_grado').selectpicker('refresh');
        });

        // //Seleccionamos seccion predeterminada
        $.post("../ajax/registroalumnos.php?op=seleccionarSeccionInicial", function(r) {
            $("#id_seccion").html(r);
            $('#id_seccion').selectpicker('refresh');
        });    
    }       
    
}

//cargar competencias segun grupo competencias
function cargarcompetencias() {
    
    var id_GruComp = document.getElementById("id_GruComp").value;
    
    //mostramos las competencias por curso
	$.post("../ajax/cursos.php?op=competencias&id_GruComp=" + id_GruComp, function(r){
		$("#competencias").html(r);
	});
}


init();