var tabla;
var tbllistadocursoalumno;
var tbllistadocursoalumnotrimestre;

//Funcion que se ejecuta al inicio

function init() {
    mostrarform(false);
    listar();
    listaralumnoscurso();
    listaralumnoscursotrimestre();
    listargeneral();
    limpiartrimestral();
    cargarlistanotas();

    $("#formularioinsertarnotas").on("submit", function(e) {
        insertarnotas(e);
    })

    $("#formularioinsertarnotastrimestral").on("submit", function(e) {
        insertarnotastrimestral(e);
    })

    $("#fmreditarcompetenciastrimestrales").on("submit", function(e) {
        editarcompetenciastrimestrales(e);
    })

    //Cargamos los items al select alumno
    $.post("../ajax/miscursos.php?op=listaralumnoscursosinnota", function(r) {
        $("#idalumnocurso").html(r);
        $('#idalumnocurso').selectpicker('refresh');
    });

    //Cargamos los items al select alumno
    $.post("../ajax/miscursos.php?op=listaralumnoscursosinnotatrimestral", function(r) {
        $("#idalumnocursotri").html(r);
        $('#idalumnocursotri').selectpicker('refresh');
    });

    //editar notas trimestrales
    $("#fmreditarnotastrimestrales").on("submit", function(e) {
        editarnotastrimestrales(e);
    })

}

function activar(id_alumno) {
    $.get("../ajax/miscursos.php?op=listarcompetenciasalumno&id_alumno=" + id_alumno, function(r) {
        $("#contenido_competencias").html(r);
    });
}

//Funcion Limpiar
function limpiar() {
    $("#nota").val("");
    $("#notaasistencia").val("");
    $("#descripcion").val("");
}

function mostrarform(flag) {
    //limpiar();
    if (flag) {
        $("#listadoregistros").hide();
        $("#formularioregistros").show();
        $("#btnGuardar").prop("disabled", false);
        $("#btnagregar").hide();
    } else {
        $("#listadoregistros").show();
        $("#formularioregistros").hide();
        $("#btnagregar").show();
    }
}

function cancelarform() {
    limpiar();
    mostrarform(false);
}


function listar() {
    tabla = $('#tbllistado').dataTable({
        /*"scrollY": 200,  navegar en el datatable
        "scrollX": true, */
         "paging": true,
        // "lengthChange": true,
        // "searching": true,
        "ordering": true,
         "info": true,
         "autoWidth": false,
        
        responsive: true,
        // "scrollX": true,

        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        lengthMenu: [
            [ 5, 10, 25, 50, -1 ],
            [ '5 filas','10 filas', '25 filas', '50 filas', 'Mostrar todo' ]
        ],
        buttons: [
                  {
                        extend: 'pageLength',
                        text: 'LONGITUD DE LA PÁGINA',
                   },
                    // {
                    //     extend: 'print',
                    //     text: 'IMPRIMIR',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
                    // {
                    //     extend: 'pdf',
                    //     text: 'DESCARGAR PDF',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
		        ],
        "ajax": {
            url: '../ajax/miscursos.php?op=listar',
            type: "get",
            dataType: "json",
            error: function (e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 25, //Paginación
        "order": [[0, "asc"]], //Ordenar (columna,orden)
        language: {
            zeroRecords: 'No hay registros para mostrar.',
            info: "Mostrando página _PAGE_ de _PAGES_ páginas",
            search: 'BUSCAR',
            emptyTable: 'La tabla está vacia.',
            "oPaginate": {
            "sFirst":    "Primero",
            "sLast":     "Ultimo",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior",
            }
        }
    }).DataTable();
}

function listargeneral() {
    tabla = $('#tbllistadogeneral').dataTable({
        /*"scrollY": 200,  navegar en el datatable
        "scrollX": true, */
         "paging": true,
        // "lengthChange": true,
        // "searching": true,
        "ordering": true,
         "info": true,
         "autoWidth": false,
        
        responsive: true,
        // "scrollX": true,

        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        lengthMenu: [
            [ 5, 10, 25, 50, -1 ],
            [ '5 filas','10 filas', '25 filas', '50 filas', 'Mostrar todo' ]
        ],
        buttons: [
                  {
                        extend: 'pageLength',
                        text: 'LONGITUD DE LA PÁGINA',
                   },
                    // {
                    //     extend: 'print',
                    //     text: 'IMPRIMIR',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
                    // {
                    //     extend: 'pdf',
                    //     text: 'DESCARGAR PDF',
                    //     title: 'Usuarios BYTE SEVEN'
                    // },
		        ],
        "ajax": {
            url: '../ajax/miscursos.php?op=listargeneral',
            type: "get",
            dataType: "json",
            error: function (e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 25, //Paginación
        "order": [[0, "asc"]], //Ordenar (columna,orden)
        language: {
            zeroRecords: 'No hay registros para mostrar.',
            info: "Mostrando página _PAGE_ de _PAGES_ páginas",
            search: 'BUSCAR',
            emptyTable: 'La tabla está vacia.',
            "oPaginate": {
            "sFirst":    "Primero",
            "sLast":     "Ultimo",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior",
            }
        }
    }).DataTable();
}

function listaralumnoscurso() {
    tbllistadocursoalumno = $('#tbllistadocursoalumno').dataTable({
        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        buttons: [

        ],
        "ajax": {
            url: '../ajax/miscursos.php?op=listaralumnoscurso',
            type: "get",
            dataType: "json",
            error: function(e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 100, //Paginación
        "paging": false,
        "info": true,
        "order": [
                [1, "asc"]
            ] //Ordenar (columna,orden)
    }).DataTable();
}

function listaralumnoscursotrimestre() {
    tbllistadocursoalumnotrimestre = $('#tbllistadocursoalumnotrimestre').dataTable({
        "aProcessing": true, //Activamos el procesamiento del datatables
        "aServerSide": true, //Paginación y filtrado realizados por el servidor
        dom: 'Bfrtip', //Definimos los elementos del control de tabla
        buttons: [

        ],
        "ajax": {
            url: '../ajax/miscursos.php?op=listaralumnoscursotrimestre',
            type: "get",
            dataType: "json",
            error: function(e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "iDisplayLength": 100, //Paginación
        "paging": false,
        "info": true,
        "order": [
                [1, "asc"]
            ] //Ordenar (columna,orden)
    }).DataTable();
}

function mostrar(idalumnos) {
    $.post("../ajax/alumnos.php?op=mostrar", {
        idalumnos: idalumnos
    }, function(data, status) {
        data = JSON.parse(data);
        mostrarform(true);

        $("#dni").val(data.dni);
        $("#nombre").val(data.nombre);
        $("#direccion").val(data.direccion);
        $("#telefono").val(data.telefono);
        $("#idalumnos").val(data.idalumnos);

    })
}

function insertaridcurso(id_cursos) {
    $.post("../ajax/miscursos.php?op=insertaridcursodocente", {
        id_cursos: id_cursos
    }, function(e) {
        //bootbox.alert(e);
        window.location.href = '../vistas/listaralumnoscurso.php';
    });
}

function insertaridcursotrimestral(id_cursos) {
    $.post("../ajax/miscursos.php?op=insertaridcursodocente", {
        id_cursos: id_cursos
    }, function(e) {
        //bootbox.alert(e);
        window.location.href = '../vistas/listaralumnocursobimestre.php';
    });
}


function insertarnotas(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento
    $("#btnGuardar").prop("disabled", true);
    var formData = new FormData($("#formularioinsertarnotas")[0]);

    $.ajax({
        url: "../ajax/miscursos.php?op=insertarnotas",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,

        success: function(datos) {
            //bootbox.alert(datos);
            //window.alert(datos);
            //location.reload();
            if (datos == 'si') {
                tbllistadocursoalumno.ajax.reload();
                //Cargamos los items al select alumno
                $.post("../ajax/miscursos.php?op=listaralumnoscursosinnota", function(r) {
                    $("#idalumnocurso").html(r);
                    $('#idalumnocurso').selectpicker('refresh');
                });
                alertify.success("Nota ingresada con exito !");
                var nom_curso = document.getElementById('nom_curso').value;
                var nom_nivel = document.getElementById('nom_nivel').value;
                if (nom_nivel == 'PRIMARIA') {
                    if (nom_curso == 'ASISTENCIA') {
                        $("#notaasistencia").val("");
                    } else if (nom_curso == 'OBSERVACION-TUTOR') {
                        $("#descripcion").val("");
                    } else {
                        $("#nota").val("");
                    }
                } else {
                    if (nom_curso == 'RELIGION') {
                        $("#nota").val("");
                    } else {
                        $("#nota").val("");
                        $("#notaasistencia").val("");
                    }
                }
            } else {
                alertify.error("No se pudo ingresar la  nota...");
            }

        }
    });
}

//insertarnotastrimestral
function insertarnotastrimestral(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento
    $("#btnGuardar").prop("disabled", true);
    var formData = new FormData($("#formularioinsertarnotastrimestral")[0]);
    $.ajax({
        url: "../ajax/miscursos.php?op=insertarnotastrimestral",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos) {
            //alert(datos);
            if (datos ==  1) {
                swal("Nota registrada correctamente!", {icon: "success",});

                tbllistadocursoalumno.ajax.reload();
                //Cargamos los items al select alumno            
                $.post("../ajax/miscursos.php?op=listaralumnoscursosinnotatrimestral", function(r) {
                    $("#idalumnocursotri").html(r);
                    $('#idalumnocursotri').selectpicker('refresh');
                });
                limpiartrimestral();
                listaralumnoscursotrimestre();
            }else{
                swal("Error al registrar nota!", {icon: "error",});                
            }
        }
    });
}

function limpiartrimestral() {
    $("#nota_tri_compe_1").val("");
    $("#nota_tri_compe_2").val("");
    $("#nota_tri_compe_3").val("");
    $("#nota_tri_compe_4").val("");
    $("#nota_tri_compe_5").val("");
    $("#asistencia").val("");
    $("#descripcion").val("");
    $("#descripcion_1").val("");
    $("#descripcion_2").val("");
    $("#descripcion_3").val("");
    $("#descripcion_4").val("");
    $("#descripcion_5").val("");
    $("#nota_tri_final").val("");

    $("#idnota_tri").val("");
    $("#editar_nota_tri").val("");

}

function regresarmiscursos() {
    location.href = "../vistas/miscursos.php";
}

function registrocompletado(id_curos) {
    swal({
        title: "Buen trabajo!",
        text: "Registro de notas completado!",
        icon: "success",
        button: "OK!",
      }).then(()=>{                            
        insertaridcursotrimestral(id_curos);
    });
}

function editarcompetenciastrimestrales(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento    
    var formData = new FormData($("#fmreditarcompetenciastrimestrales")[0]);
    $.ajax({
        url: "../ajax/miscursos.php?op=editarcompetenciastrimestrales",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,

        success: function(datos) {
            //alertify.success(datos);
            if (datos == 'si') {
                tbllistadocursoalumnotrimestre.ajax.reload();
                alertify.success("Editado con exito !");
                $('#modalEditarCompetencias').modal('toggle');
            } else {
                alertify.error("No se pudo editar...");
            }
        }
    });
}

function mostrarnotaeditarbimestral(id_notatri) {
    $.post("../ajax/miscursos.php?op=datosnotasbimestrales", {
        id_notatri: id_notatri
    }, function(data, status) {
        data = JSON.parse(data);        
        const miLabel = document.getElementById("nombrecurso_tri");
        miLabel.textContent = data.comp_nombre;        
        $("#idnota_tri").val(data.id_notastrimestrales );        
    })
    cargarlistanotas();
}

function cargarlistanotas() {
    $.post("../ajax/miscursos.php?op=listarnotascualitativas", function(r) {
        $("#editar_nota_tri").html(r);
        $('#editar_nota_tri').selectpicker('refresh');
    });
    
    $.post("../ajax/miscursos.php?op=listarnotascualitativas", function(r) {
        $("#nota_tri_compe_1").html(r);
        $('#nota_tri_compe_1').selectpicker('refresh');
    }); 

    $.post("../ajax/miscursos.php?op=listarnotascualitativas", function(r) {
        $("#nota_tri_compe_2").html(r);
        $('#nota_tri_compe_2').selectpicker('refresh');
    }); 

    $.post("../ajax/miscursos.php?op=listarnotascualitativas", function(r) {
        $("#nota_tri_compe_3").html(r);
        $('#nota_tri_compe_3').selectpicker('refresh');
    }); 

    $.post("../ajax/miscursos.php?op=listarnotascualitativas", function(r) {
        $("#nota_tri_compe_4").html(r);
        $('#nota_tri_compe_4').selectpicker('refresh');
    }); 

    $.post("../ajax/miscursos.php?op=listarnotascualitativas", function(r) {
        $("#nota_tri_compe_5").html(r);
        $('#nota_tri_compe_5').selectpicker('refresh');
    }); 
}

//editar nostas trimestrales
function editarnotastrimestrales(e) {
    e.preventDefault(); //No se activará la acción predeterminada del evento    
    var formData = new FormData($("#fmreditarnotastrimestrales")[0]);
    $.ajax({
        url: "../ajax/miscursos.php?op=editarnotatrimestral",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,

        success: function(datos) {        
            if (datos == 1) {                
                swal("Se edito la nota correctamente!", {
                    icon: "success",
                });
                tbllistadocursoalumnotrimestre.ajax.reload();
                $('#modalEditarCompetencias').modal('toggle');
            } else {                
                swal("Error al editar la nota!", {
                    icon: "error",
                });
                $('#modalEditarCompetencias').modal('toggle');
            }
        }
    });
    limpiartrimestral();
}


init();