<?php
    require_once "../modelos/Consultas.php";
    date_default_timezone_set('America/Lima');
    $consultas = new Consultas();

    //verificar anio escolar activo
    $anioactual = $consultas->anioescolaractual();
    
    if (empty($anioactual)) {
        echo ""?> 
            <!-- inicio anio escolar -->
            <div id="IniciarAnioEscolar">
                <header class="main-box-header clearfix">
                    <h1 class="box-title">REGISTRAR AÑO ESCOLAR</h1>      
                </header>
                <div class="main-box-body clearfix" id="">
                    <form name="fmranioescolar" id="fmranioescolar" method="POST">
                        <div class="row">
                            <div class="form-group col-sm-2 col-xs-12">
                                <label>Fecha inicio</label>             
                                <input type="date" name="f_ini_anio" id="f_ini_anio" class="form-control"  required>
                            </div>
                            <div class="form-group col-sm-2 col-xs-12">
                                <label>Fecha fin</label>             
                                <input type="date" name="f_fin_anio" id="f_fin_anio" class="form-control"  required>
                            </div>   
                            <div class="form-group col-sm-2 col-xs-12">
                                <label>Año escolar</label>             
                                <input type="number" name="f_anio_esco" id="f_anio_esco" class="form-control" required>
                            </div>          
                        </div>                                                                         
                        <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <button class="btn btn-primary" type="submit" id="btnGuardar"><i class="fa fa-save"></i> Guardar</button>             
                        </div>
                    </form>
                </div>
            </div>
       <?php echo ""; 
    }else {
        //OBTENER DATOS DEL ANIO ESCOLAR
        $anioescolar = $consultas->anioescolaractual();
        $datos = $consultas->estadomesevaluado();

        echo "";?>
            <div>
                <header class="main-box-header clearfix">
                    <h1 class="box-title">FINALIZAR AÑO ESCOLAR: <?php echo ' '.$anioescolar['aea_anio']; ?>  </h1> 
                    <button class="btn btn-primary" onclick="finalizaranioescolar()" type="button"><i class="fa fa-save"></i> Finalizar</button>
                </header>
            </div>
        <?php
        echo "";

        if (empty($datos)) {
            $Meses = array('ENERO', 'FEBRERO', 'MARZO', 'ABRIL', 'MAYO', 'JUNIO', 'JULIO', 'AGOSTO', 'SEPTIEMBRE', 'OCTUBRE', 'NOVIEMBRE', 'DICIEMBRE'); 
            $aux = $consultas->ultimomesevaluado();

            if (empty($aux)) {
                $clave = 0;
            }else {
                $clave = array_search($aux['ep_mes'], $Meses);           
            }

            echo "";?>
                <header class="main-box-header clearfix">
                    <h1 class="box-title">APERTURAR EVALUACIÓN MENSUAL</h1>
                </header>  
                <div class="main-box-body clearfix" id="">
                    <form name="fmrmesevaluado" id="fmrmesevaluado" method="POST">
                        <div class="row">
                            <div class="form-group col-sm-2 col-xs-12">
                                <label>Fecha inicio</label>             
                                <input type="date" name="ini_mes_evaluacion" id="ini_mes_evaluacion" class="form-control" required>
                            </div>
                            <div class="form-group col-sm-2 col-xs-12">
                                <label>Fecha fin registro notas</label>             
                                <input type="date" name="fin_mes_evaluacion" id="fin_mes_evaluacion" class="form-control" required>
                            </div>            
                            <div class="form-group col-sm-2 col-xs-12">
                                <label>Més</label>                                                      
                                <select name="mes_evaluacion" id="mes_evaluacion" class="form-control" required>
                                    <option value="" selected disabled>---------</option>
                                    <?php for ($i = $clave+1; $i < 12; $i++) { 
                                    echo "";?>
                                        <option value="<?php echo $Meses[$i]?>"><?php echo $Meses[$i] ?></option>
                                    <?php }
                                    echo "";?>
                                </select>
                            </div>
                        </div>                                                                         
                        <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <button class="btn btn-primary" type="submit" id="btnGuardar"><i class="fa fa-save"></i>  Aperturar més de evaluacion</button>             
                        </div>
                    </form>
                </div>
            <?php
            echo "";
        }else {

            echo "";?>
                <header class="main-box-header clearfix">
                    <h1 class="box-title">ETAPA DE EVALUACION MENSUAL: <?php echo ' '.$datos['ep_mes']; ?></h1>     
                </header>
                <header class="main-box-header clearfix">
                    <h2 class="box-title">Extender tiempo de ingreso de notas</h2>    
                </header>
                <div class="box-header with-border" id="">
                    <form name="fmrnuevafechaevaluacion" id="fmrnuevafechaevaluacion" method="POST">
                    <div class="row">
                        <div class="form-group col-sm-2 col-xs-12">
                            <label>Fecha limite</label>             
                            <input type="text" value = "<?php echo $datos['ep_fin'];?>" name="" id="" class="form-control" disabled>
                        </div>
                        <div class="form-group col-sm-2 col-xs-12">
                            <label>Nueva fecha limite</label>             
                            <input type="date" value = "<?php echo $datos['ep_fin'];?>" name="nueva_fecha" id="nueva_fecha" class="form-control" required>
                        </div>                                                                                               
                        <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <button class="btn btn-primary" type="submit" id="btnGuardar"><i class="fa fa-save"></i> Extender tiempo de evaluacion</button>             
                            <button class="btn btn-primary" onclick="finalizarmesevaluacion()" type="button"><i class="fa fa-save"></i> Finalizar</button>
                        </div>
                    </div>
                    </form>
                </div>
            <?php
            echo "";

        }
        //etapa bimestral

        $datostrimestre = $consultas->estadotrimestreevaluadi();
        if ( empty($datostrimestre)) {
            $trimestre = array('I','II','III','IV'); 
            $aux2 = $consultas->ultimotrimestreevaluado();
            if (empty($aux2)) {          
                $clavetri = -1;
            }else {
                $clavetri = array_search($aux2['et_trimestre'], $trimestre);            
            }  

                echo "";?>
                    <header class="main-box-header clearfix">
                        <h1 class="box-title">APERTURAR EVALUACIÓN BIMESTRAL</h1>
                    </header>  
                    <div class="main-box-body clearfix" id="">
                        <form name="fmrtrievaluado" id="fmrtrievaluado" method="POST">
                            <div class="row">
                                <div class="form-group col-sm-2 col-xs-12">
                                    <label>Fecha inicio</label>             
                                    <input type="date" name="ini_tri_evaluacion" id="ini_tri_evaluacion" class="form-control" required>
                                </div>
                                <div class="form-group col-sm-2 col-xs-12">
                                    <label>Fecha fin registro notas</label>             
                                    <input type="date" name="fin_tri_evaluacion" id="fin_tri_evaluacion" class="form-control" required>
                                </div>            
                                <div class="form-group col-sm-2 col-xs-12">
                                    <label>Bimestre</label>                                                      
                                    <select name="tri_evaluacion" id="tri_evaluacion" class="form-control" required>
                                        <option value="" selected disabled>---------</option>
                                        <?php for ($i = $clavetri +1; $i < 4; $i++) { 
                                        echo "";?>
                                            <option value="<?php echo$trimestre[$i];?>"><?php echo $trimestre[$i];?> BIMESTRE</option>
                                        <?php
                                        }
                                        echo "";?>
                                    </select>
                                </div>
                            </div>                                                                         
                            <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <button class="btn btn-primary" type="submit" id="btnGuardar"><i class="fa fa-save"></i> Aperturar bimestre de evaluacion</button>             
                            </div>
                        </form>
                    </div>
                <?php
                echo "";
            }else {
                echo "";?>
                    <header class="main-box-header clearfix">
                        <h1 class="box-title">ETAPA DE EVALUACION BIMESTRAL: <?php echo ' '.$datostrimestre['et_trimestre'];?> BIMESTRE </h1>     
                    </header>
                    <header class="main-box-header clearfix">
                        <h2 class="box-title">Extender tiempo de ingreso de notas</h2>    
                    </header>
                    <div class="main-box-body clearfix" id="">
                        <form name="fmrnuevafechaevaluaciontrimestre" id="fmrnuevafechaevaluaciontrimestre" method="POST">
                            <div class="row">
                                <div class="form-group col-sm-2 col-xs-12">
                                    <label>Fecha limite</label>             
                                    <input type="text" value = "<?php echo $datostrimestre['et_fin'];?>" name="" id="" class="form-control" disabled>
                                </div>
                                <div class="form-group col-sm-2 col-xs-12">
                                    <label>Nueva fecha limite</label>             
                                    <input type="date" value = "<?php echo $datostrimestre['et_fin'];?>" name="nueva_fecha_tri" id="nueva_fecha_tri"  class="form-control" required>
                                </div>                                                                                               
                                <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <button class="btn btn-primary" type="submit" id="btnGuardar"><i class="fa fa-save"></i> Extender tiempo de evaluacion</button>             
                                    <button class="btn btn-primary" onclick="finalizartrimestreevaluacion()" type="button"><i class="fa fa-save"></i> Finalizar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                <?php
                echo "";
            }

    }
?>
